SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-------------------------------------------------------------------------------------------------------------------------------------
-- Add new table HistoricResponse to keep Response History for each call of a Respondent for a given list of questions
-------------------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id('[HistoricResponse]') AND OBJECTPROPERTY(id, 'IsUserTable') = 1)
BEGIN  
  CREATE TABLE HistoricResponse
  (
		Id         int identity NOT NULL,
		Respondent varchar(10) NOT NULL,
		CallId     int NOT NULL,
		Question   nvarchar(32) NOT NULL,
		Matrix     bigint NOT NULL,
		Mention    int NOT NULL,
		[Content]  nvarchar(100) NULL,
		OpenEnd    nvarchar(max) NULL,
		modifiedBy int NOT NULL,
		modified   datetime NOT NULL
 CONSTRAINT [PK_HistoricResponse] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
ALTER TABLE HistoricResponse
 ADD CONSTRAINT FK_HistoricResponse_Historic FOREIGN KEY (Respondent,CallId)
 REFERENCES Historic(HisRespondent,HisCallNumber)
GO

-------------------------------------------------------------------------------------------------------------------------------------
-- Add new field IsImported to be used by the HistoricResponse trigger
-------------------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'IsImported' AND object_id = OBJECT_ID(N'Historic'))
BEGIN
  ALTER TABLE Historic ADD IsImported bit default(0) NOT NULL
END
GO

-------------------------------------------------------------------------------------------------------------------------------------
-- Add new trigger on Historic table to fill the HistoricResponse table for a given list of questions
-------------------------------------------------------------------------------------------------------------------------------------
/****** Object:  Trigger [VX_TR_ReponseModifLog]    Script Date: 04/10/2013 10:52:08 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_HistoricResponse_Insert]'))
DROP TRIGGER [dbo].[VX_TR_HistoricResponse_Insert]
GO

IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_HistoricResponse_Insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[VX_TR_HistoricResponse_Insert]
   ON  [dbo].[Historic]
   AFTER INSERT
AS 
BEGIN
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON;
-- From the Installation configuration, the option for Audit of the Response table.
  INSERT INTO dbo.HistoricResponse 
     (Respondent, CallId, Question, Matrix, Mention, Content, OpenEnd, ModifiedBy, Modified)
    SELECT inserted.HisRespondent, inserted.HisCallNumber, r.RpsQuestion, r.RpsMatrix, r.RpsMention, r.RpsContent, r.RpsOpened, r.modifiedby, r.modified
    FROM inserted
    join Response r	on  r.RpsRespondent = inserted.HisRespondent
    WHERE EXISTS (SELECT 1 FROM Installation WHERE INSSECTION = ''TRACKHISTORICRESPONSE'' and INSIDENT LIKE ''QUESTION![%!]'' ESCAPE ''!'' and INSVALUE = r.RpsQuestion)
    AND inserted.IsImported = 0
END
' 
GO

-------------------------------------------------------------------------------------------------------------------------------------
-- Modification to Sp_updaterespondenthistory to add parameter IsImported to be inserted in HistoricTable
-------------------------------------------------------------------------------------------------------------------------------------
IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_updaterespondenthistory]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [dbo].[Sp_updaterespondenthistory]
GO
CREATE PROCEDURE [dbo].[Sp_updaterespondenthistory]
                @ProjectId           INT,
                @CollectMode         INT,
                @HisRespondent       VARCHAR(10),
                @HisCallNumber       INT,
                @HisInterviewer      VARCHAR(10),
                @HisResult           VARCHAR(2),
                @HisCallDate         DATETIME,
                @HisTimeSlot         INT,
                @HisCallDuration     INT,
                @HisDataType         INT,
                @HisStartQuestion    VARCHAR(10),
                @HisEndQuestion      VARCHAR(10),
                @HisMonitoring       BIT,
                @HisDialerLine       INT,
                @HisWait             INT,
                @HisPause            INT,
                @HisFileReference    VARCHAR(120),
                @HisPreviousCallDate DATETIME,
                @HisLifeState        VARCHAR(2),
                @HisPhone            VARCHAR(20) = NULL,
                @DialingMode         INT = NULL, -- Null => Do not change
                @LevelChanged        BIT = 0,
                @Notes               NVARCHAR(MAX) = NULL,
                @RuleId              INT = NULL,
                @ExtRuleId           INT = NULL,
                @NextCBKDate         DATETIME = NULL,
				@IsImported          BIT = 0
AS
  UPDATE historic
  SET    hisrespondent = @HisRespondent,
         hiscallnumber = @HisCallNumber,
         hisinterviewer = @HisInterviewer,
         hisresult = @HisResult,
         hiscalldate = @HisCallDate,
         histimeslot = @HisTimeSlot,
         hiscallduration = @HisCallDuration,
         hisdatatype = @HisDataType,
         hisstartquestion = @HisStartQuestion,
         hisendquestion = @HisEndQuestion,
         hismonitoring = @HisMonitoring,
         hisdialerline = @HisDialerLine,
         hiswait = @HisWait,
         hispause = @HisPause,
         hisfilereference = @HisFileReference,
         hispreviouscalldate = @HisPreviousCallDate,
         hislifestate = @HisLifeState,
         projectid = @projectId,
         collectmode = @collectMode,
         HisPhone = @HisPhone,
         DialingMode = IsNull(@DialingMode,DialingMode),
         LevelChanged = @LevelChanged,
         Notes = @Notes,
         RuleId = @RuleId,
         ExtRuleId = @ExtRuleId,
         NextCallBack = @NextCBKDate,
		 IsImported = @IsImported
  WHERE  hisrespondent = @HisRespondent
         AND hiscallnumber = @HisCallNumber
         
  IF @@ROWCOUNT = 0
    BEGIN
      INSERT INTO historic
                 (hisrespondent,
                  hiscallnumber,
                  hisinterviewer,
                  hisresult,
                  hiscalldate,
                  histimeslot,
                  hiscallduration,
                  hisdatatype,
                  hisstartquestion,
                  hisendquestion,
                  hismonitoring,
                  hisdialerline,
                  hiswait,
                  hispause,
                  hisfilereference,
                  hispreviouscalldate,
                  hislifestate,
                  projectid,
                  collectmode,
                  HisPhone,
                  DialingMode,
                  LevelChanged,
                  Notes,
                  RuleId,
                  ExtRuleId,
                  NextCallBack,
				  IsImported)
      VALUES     (@HisRespondent,
                  @HisCallNumber,
                  @HisInterviewer,
                  @HisResult,
                  @HisCallDate,
                  @HisTimeSlot,
                  @HisCallDuration,
                  @HisDataType,
                  @HisStartQuestion,
                  @HisEndQuestion,
                  @HisMonitoring,
                  @HisDialerLine,
                  @HisWait,
                  @HisPause,
                  @HisFileReference,
                  @HisPreviousCallDate,
                  @HisLifeState,
                  @projectId,
                  @collectMode, 
                  @HisPhone,
                  IsNull(@DialingMode,0),
                  @LevelChanged,
                  @Notes,
                  @RuleId,
                  @ExtRuleId,
                  @NextCBKDate,
				  @IsImported)
    END
GO

-------------------------------------------------------------------------------------------------------------------------------------
-- Creation of Sp_InsertHistoricResponse 
-------------------------------------------------------------------------------------------------------------------------------------
IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_InsertHistoricResponse]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [dbo].[Sp_InsertHistoricResponse]
GO
/****** Object:  StoredProcedure [dbo].[Sp_InsertHistoricResponse]    Script Date: 03/07/2012 15:33:16 ******/
CREATE PROCEDURE [dbo].[Sp_InsertHistoricResponse]
                @Respondent			VARCHAR(10),
                @CallId				INT,
                @Question			NVARCHAR(32),
                @Matrix				BIGINT,
                @Mention			INT,
                @Content			NVARCHAR(100),
                @OpenEnd			NVARCHAR(MAX),
                @ModifiedBy			INT
AS
  INSERT INTO HistoricResponse
			 (Respondent,
			  CallId,
              Question,
              Matrix,
              Mention,
              Content,
              OpenEnd,
              ModifiedBy,
              Modified)
      VALUES (@Respondent,
              @CallId,
              @Question,
              @Matrix,
              @Mention,
              @Content,
              @OpenEnd,
              @ModifiedBy,
              GETUTCDATE())
GO

-------------------------------------------------------------------------------------------------------------------------------------
-- Modification to Sp_resetprojectdata to add truncate of table HistoricResponse and replace Truncate by delete for Historic table
-------------------------------------------------------------------------------------------------------------------------------------
IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_resetprojectdata]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [dbo].[Sp_resetprojectdata]
GO
CREATE PROCEDURE [dbo].[Sp_resetprojectdata]
AS
  EXEC Sp_resetbuffernew
  DELETE FROM Note
  DELETE FROM HistoricResponse
  DELETE FROM Historic
  DELETE FROM Stratum
  DELETE FROM TimeSlotHit
  DELETE FROM Response
  DELETE FROM ImportHistory
  DELETE FROM RespondentPIN
  DELETE FROM RespondentState
  DELETE FROM ImportedFields
  DELETE FROM respondent
  DELETE FROM RespondentModifLog
  DELETE FROM ResponseModifLog
  DELETE FROM TIMESLOTHIT
  DELETE FROM CAPI_CasesToSendBack
  UPDATE quota
  SET    qtonline = 0,
         qtunused = 0,
         qtfrequence = 0,
         qtstatustemp = 0
  UPDATE quotasagent
  SET    Frequency = 0

	/*DE659*/
	INSERT INTO [ResetDataHistory]
	(Description,ResetDate)
	SELECT 'Data was reset on the server',GETUTCDATE()
GO

-------------------------------------------------------------------------------------------------------------------------------------
-- Modification to Sp_deleterespondent to add delete of of respondent in HistoricResponse table
-------------------------------------------------------------------------------------------------------------------------------------
IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_deleterespondent]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [dbo].[Sp_deleterespondent]
GO
CREATE PROCEDURE [dbo].[Sp_deleterespondent]
                @Quest VARCHAR(10)
AS
  IF @quest <> ''
    BEGIN
      DELETE FROM note
      WHERE       notrespondent = @Quest
      DELETE FROM historicResponse
      WHERE       Respondent = @Quest
      DELETE FROM historic
      WHERE       hisrespondent = @Quest
      DELETE FROM stratum
      WHERE       strrespondent = @Quest
      DELETE FROM timeslothit
      WHERE       tshrespondent = @Quest
      DELETE FROM response
      WHERE       rpsrespondent = @Quest
      DELETE FROM respondent
      WHERE       resrespondent = @Quest
    END
GO
